#ifndef ZMODELER_STRUCT_TYPES_INCLUDED
#define ZMODELER_STRUCT_TYPES_INCLUDED

////////////////////
// For storing Flags
typedef DWORD FlagInt;


//////////////////////
// For storing indexes
typedef long tIndex;



////////////////////
// view types
typedef enum ViewMode
{
  Z3D_VIEWMODE_NONE       = 100,
  Z3D_VIEWMODE_TOP        = 101,
  Z3D_VIEWMODE_BOTTOM     = 102,
  Z3D_VIEWMODE_LEFT       = 103,
  Z3D_VIEWMODE_RIGHT      = 104,
  Z3D_VIEWMODE_FRONT      = 105,
  Z3D_VIEWMODE_BACK       = 106,
  Z3D_VIEWMODE_MAPPER     = 107,
  Z3D_VIEWMODE_3D         = 108,
  Z3D_VIEWMODE_USER       = 109,
  Z3D_VIEWMODE_LAST       = 110,
  Z3D_VIEWMODE_FORCE_DWORD_COMPILE = 0x7FFFFFFF
};

typedef enum sObjectsType
{
  Z3D_OBJTYPE_ALL,
  Z3D_OBJTYPE_SELECTED,
  Z3D_OBJTYPE_MARKED,
  Z3D_OBJTYPE_HIDDEN,
  Z3D_OBJTYPE_DISABLED,
  Z3D_OBJTYPE_ENABLED,
  Z3D_OBJTYPE_NOTHIDDEN,
  Z3D_OBJTYPE_NOTSELECTED,
  Z3D_OBJTYPE_NOTMARKED,
  Z3D_OBJTYPE_FORCE_DWORD_COMPILE = 0x7FFFFFFFL
}sObjectsType;


typedef enum sButtonType
{
  Z3D_BUTTON_DONE,
  Z3D_BUTTON_CANCEL,
  Z3D_BUTTON_SELECTALL,
  Z3D_BUTTON_DESELECTALL,
  Z3D_BUTTON_ACTION_HIDE,
  Z3D_BUTTON_ACTION_UNHIDE,
  Z3D_BUTTON_ACTION_SELECT,
  Z3D_BUTTON_ACTION_UNSELECT,
  Z3D_BUTTON_ACTION_DISABLE,
  Z3D_BUTTON_ACTION_ENABLE,
  Z3D_BUTTON_ACTION_DELETE,
  Z3D_BUTTON_FORCE_DWORD_COMPILE = 0x7FFFFFFFL
}sButtonType;


typedef enum sRequestType
{
  Z3D_REQUEST_ENTERNAME              = 10,
  Z3D_REQUEST_BYNAMEBOX              = 11,
  Z3D_REQUEST_SELECT_BYNAME          = 20,
  Z3D_REQUEST_DESELECT_BYNAME        = 21,
  Z3D_REQUEST_HIDE_BYNAME            = 30,
  Z3D_REQUEST_UNHIDE_BYNAME          = 31,
  Z3D_REQUEST_DISABLE_BYNAME         = 40,
  Z3D_REQUEST_ENABLE_BYNAME          = 41,
  Z3D_REQUEST_SELECTUNSUPPORTEDDATA  = 50,//un-data browser dialog
  Z3D_REQUEST_GETUNRECOGNIZEDDATA    = 51,
  Z3D_REQUEST_ATTRIBUTESDIALOG       = 60,//attributes dialog
  Z3D_REQUEST_SELECTMISCVALUE        = 70,//miscvalues dialog
  Z3D_REQUEST_GETTOOLBARSARRAY       = 80,
  Z3D_REQUEST_GETFLOATBARSARRAY      = 81,
  Z3D_REQUEST_GETMENUITEMSARRAY      = 82,
  Z3D_REQUEST_GETMENUBAR             = 83,
  Z3D_REQUEST_GETPLUGSARRAY          = 84,
  Z3D_REQUEST_VALUEENTER             = 90,
  Z3D_REQUEST_STRINGENTER            = 91,

  Z3D_REQUEST_UPDATEMENT             = 100,
  Z3D_REQUEST_REDRAW3DVIEWS          = 101,
  Z3D_REQUEST_TEXTUREVIEWDIALOG      = 110,
  Z3D_REQUEST_TEXTURESELECTDIALOG    = 111,//same as texreviewdialog
  Z3D_REQUEST_MATERIALEDITOR         = 120,//returns zero-based index of material or -1 on cancel
  Z3D_REQUEST_SELECT_MATERIAL        = 121,//selects single material from drop-list
  Z3D_REQUEST_CHOOSETOOL             = 130,//selects a tool
  Z3D_REQUEST_ADDTIMERCALLBACK       = 140,//creates a timer and associates callback with it
  Z3D_REQUEST_REMOVETIMERCALLBACK    = 141,//removes timer and callback by supplied index
  Z3D_REQUEST_GETNUMERICPARAMETER    = 150,
  Z3D_REQUEST_SETNUMERICPARAMETER    = 151,

  Z3D_REQUEST_ADDVIEWDRAWCALLBACK    = 170,//unsupported
  Z3D_REQUEST_REMOVEVIEWDRAWCALLBACK = 171,//unsupported

  Z3D_REQUEST_ADD_ANIMATIONCALLBACK  = 172,//Objects is a (PLUGPROCESSORPROC)Objects;
                                           //param1 points to long with "StartFrame"
                                           //param2 points to long with "SkipFrame"
                                           //returns an ID.
  Z3D_REQUEST_REMOVE_ANIMATIONCALLBACK = 173, //param1 points to long with ID, returned by ADD_


//(*param2) 1,2,3,4 and NULL/0 for "active", param1 is z3dViewDescriptor*
  Z3D_REQUEST_GETVIEWDESCRIPTOR      = 180,
  Z3D_REQUEST_SETVIEWDESCRIPTOR      = 181,
//param2 - same, param1 - always NULL
  Z3D_REQUEST_SETVIEWFROMD3D         = 182,
  
  Z3D_REQUEST_PUSHMODESBUTTONS       = 190,

  Z3D_REQUEST_ADDSETTINGSPAGE        = 200,//param1 is (CPropertyPage*). Returns it's index.
  Z3D_REQUEST_SHOWSETTINGSPAGE       = 201,//param1 is (long*) with an index, returned by Z3D_REQUEST_ADDSETTINGSPAGE
  Z3D_REQUEST_REMOVESETTINGSPAGE     = 202,

  Z3D_REQUEST_ADDATTRIBUTESPAGE      = 205,//param1 is (CPropertyPage*). Returns it's index
  Z3D_REQUEST_SHOWATTRIBUTESPAGE     = 206,//param1 is (long*) with an index, returned by Z3D_REQUEST_ADDATTRIBUTESPAGE
  Z3D_REQUEST_REMOVEATTRIBUTESPAGE   = 207,

  //param1 is (CString*)CString with branch.
  Z3D_REQUEST_GETLOCALIZATIONBRANCH  = 210,
  //param1 is (CString*) with branch, param2 is (CString*) with name.
  Z3D_REQUEST_GETLOCALIZATIONNAME    = 211,
  //Default string is localization base. param1 is (CWnd*)pMyDialog.
  Z3D_REQUEST_LOCALIZE_USER_DIALOG   = 212,
  //Default string is localization base. param1 is (CWnd*)pItem.
  Z3D_REQUEST_LOCALIZE_USER_COMBOBOX = 213,
  Z3D_REQUEST_LOCALIZE_USER_LISTBOX  = 214,

  Z3D_REQUEST_FORCE_DWORD_COMPILE    = 0x7FFFFFFFL
}sRequestType;


typedef enum sBackupType
{
  Z3D_BACKUP_COORD          = 0x10,
  Z3D_BACKUP_NORM           = 0x11,
  Z3D_BACKUP_COORDNORM      = 0x12,
  
  Z3D_BACKUP_INDEXMAP       = 0x20,
  Z3D_BACKUP_UV             = 0x21,
  Z3D_BACKUP_UVANDMATERIAL  = 0x22,
  Z3D_BACKUP_FACEMATERIAL   = 0x23,
  
  Z3D_BACKUP_FLAGS          = 0x30,
  Z3D_BACKUP_ALLFLAGS       = 0x31,
  
  Z3D_BACKUP_VERTICES       = 0x40,
  Z3D_BACKUP_FACES          = 0x50,
  
  Z3D_BACKUP_MESH           = 0x60,
  Z3D_BACKUP_GEOMETRY       = 0x61,
  Z3D_BACKUP_TRANSFORM      = 0x62,//matrix

  Z3D_BACKUP_SCENE          = 0x70,
  Z3D_BACKUP_FORADDITION    = 0x71,
  
  Z3D_BACKUP_SPLINES        = 0x80,
  
  Z3D_BACKUP_MATERIALS      = 0x90,
  Z3D_BACKUP_FORCE_DWORD_COMPILE = 0x7FFFFFFFL
}sBackupType;


////////////////////
// Three edit modes
typedef enum z3dEditMode
{
  Z3D_EDITMODE_X,
  Z3D_EDITMODE_Y,
  Z3D_EDITMODE_Z,
  Z3D_EDITMODE_H,
  Z3D_EDITMODE_V,
  Z3D_EDITMODE_D,
  Z3D_EDITMODE_HV,
  Z3D_EDITMODE_FORCE_DWORD_COMPILE = 0x7FFFFFFFL
};


////////////////////
// Three Levels
typedef enum z3dLevels
{
  Z3D_LEVEL_NONE                = 0x00,
  Z3D_LEVEL_VERTICES            = 0x10,
  Z3D_LEVEL_NORMALS             = 0x11,  //not implemented
  Z3D_LEVEL_SPLINES             = 0x40,
  Z3D_LEVEL_SPLINEVERTICES      = 0x41,
  Z3D_LEVEL_EDGES               = 0x20,
  Z3D_LEVEL_FACES               = 0x30,
  Z3D_LEVEL_OBJECTS             = 0x50,
  Z3D_LEVEL_FORCE_DWORD_COMPILE = 0x7FFFFFFFL
};


////////////////////
// Current States
typedef enum z3dState
{
  Z3D_STATE_WAITFOR_FIRSTCLICK         = 0,
  Z3D_STATE_WAITFOR_SECONDCLICK        = 1,
  Z3D_STATE_WAITFOR_THIRDCLICK         = 2,
  Z3D_STATE_WAITFOR_FOURTHCLICK        = 3,
  Z3D_STATE_WAITFOR_FIFTHCLICK         = 4,
  Z3D_STATE_WAITFOR_INTERMEDIATECLICK  = 5,
  Z3D_STATE_WAITFOR_LASTCLICK          = 6,
  Z3D_STATE_FORCE_DWORD_COMPILE        = 0x7FFFFFFFL
};

/////////////////////////
// Unsopported data types
typedef enum z3dUnDataType
{
  Z3D_UNDATA_UNKNOW       = 0,
  Z3D_UNDATA_TEXTURE      = 1,
  Z3D_UNDATA_COLORS       = 2,
  Z3D_UNDATA_MASK         = 3,
  Z3D_UNDATA_MISCVALUES   = 4,
  Z3D_UNDATA_MISCFLAGS    = 5,
  Z3D_UNDATA_TEXT         = 6,
  Z3D_UNDATA_FILEHEADER   = 7,
  Z3D_UNDATA_ALL          = 8,
  Z3D_UNDATA_FORCE_DWORD_COMPILE = 0x7FFFFFFFL
};


//-------------------------------------------------------------
// Function pointers used in ZModeler:
//-------------------------------------------------------------

typedef DWORD  (CALLBACK *PLUGLONGPARAMPROC)(long);
typedef WORD   (CALLBACK *PLUGSHORTPARAMPROC)(long);
typedef char*  (CALLBACK *PLUGCHARPARAMPROC)(long);
typedef DWORD  (CALLBACK *PLUGPTRASPARAMPROC)(void*);


class  tObjectSet;
class  tObject;
class  tSplines;
struct tPOINT;
class  CDirect3D;
class  tUnDataSet;
class  tUndoStack;
struct tProcParams;
struct z3dViewDescriptor;
class  CRollUpBar;

typedef DWORD  (CALLBACK *VISUAL_UPDATE)(tObject* pObj);
typedef DWORD  (CALLBACK *RENDER_FUNCTION)(
      tObject* pObj,
      z3dViewDescriptor* pViewDesc);
// Remark: Each render function, been called with
// (NULL, NULL) arguments, should return it's unique ID!

typedef DWORD  (FAR CALLBACK *SYSTEMREQUESTPROC)(
      sRequestType /*RT*/,
      tObjectSet* /*pObjs*/,
      char* /*pDefaultString*/,
      void* /*param1*/,
      void* /*param2*/);

typedef DWORD  (CALLBACK *PLUGPROCESSORPROC)(tProcParams* params);
typedef DWORD  (CALLBACK *PLUGUNDOPROC)( void* Buffer, tProcParams* params);

typedef DWORD  (CALLBACK *PLUGTOOLBARPROC)(DWORD num, CToolBar**, CWnd*, HINSTANCE,HINSTANCE);
typedef DWORD  (CALLBACK *PLUGFLOATBARPROC)(DWORD num, CRollUpBar**, CWnd*, HINSTANCE,HINSTANCE);

typedef DWORD  (CALLBACK *FILTERIMPEXPPROC)(CString,CWnd*,tObjectSet*,tUnDataSet*,CDirect3D*,SYSTEMREQUESTPROC, HINSTANCE/*app*/,HINSTANCE/*dll*/);


enum tRenderPriority
{
    RENDER_FIRST  = 0,
    RENDER_EARLY  = 1,
    RENDER_NORMAL = 2,
    RENDER_LATER  = 3,
    RENDER_LAST   = 4,
    RENDER_NEVER  = 5, //huh =)
    RENDER_FORCE_DWORD_COMPILE = 0x7FFFFF
};


struct z3dVisualUpdaters
{
  DWORD            BlocksProcessorID;    //unique ID
  tRenderPriority  BlockRenderPriority;
  VISUAL_UPDATE    DeleteRenderBlocks;
  VISUAL_UPDATE    UpdateRenderBlocks;
  VISUAL_UPDATE    InitRenderBlocks;

  DWORD            WireProcessorID;      //unique ID
  tRenderPriority  WireRenderPriority;
  VISUAL_UPDATE    DeleteWireBlocks;
  VISUAL_UPDATE    UpdateWireBlocks;
  VISUAL_UPDATE    InitWireBlocks;

  RENDER_FUNCTION  BlockRenderer3D;
  RENDER_FUNCTION  WireRenderer3D;
  RENDER_FUNCTION  BlockRendererView;
  RENDER_FUNCTION  WireRendererView;
};


#define    BLOCKS_BUILDKIND_SOLID 0
#define    BLOCKS_BUILDKIND_WIRE  1
#define    RENDERKIND_SOLIDVIEWS  2
#define    RENDERKIND_WIREVIEWS   3
#define    RENDERKIND_SOLID3D     4
#define    RENDERKIND_WIRE3D      5


struct z3dVisualUpdatersDescriptor
{
  char*          pszName;
  CDialog*       pSettingsDialog;
  DWORD          ProcessorID;
  DWORD          dwBuilderKind;

  VISUAL_UPDATE  Deleter;
  VISUAL_UPDATE  Updator;
  VISUAL_UPDATE  Initer;
  //pass ProcessorID data member in reserv field
  //Use pDATA as CWnd* of dialog's owner;
  PLUGPROCESSORPROC DialogCreatingProc;
  HINSTANCE         hInstance;

  //returns TRUE, if pSettingsDialog data member is valid.
  DllExport BOOL CreateSettingsDialog(CWnd* pOwner, WINDOWPLACEMENT* pwp);
  DllExport void ReleaseSettingsDialog();

  DllExport z3dVisualUpdatersDescriptor();
  DllExport ~z3dVisualUpdatersDescriptor();
};


struct z3dVisualRenderDescriptor
{
  char*            pszName;
  CDialog*         pSettingsDialog;
  RENDER_FUNCTION  Renderer;

  //pass ProcessorID data member in reserv field
  //Use pDATA as CWnd* of dialog's owner;
  //returns (CDialog*)
  PLUGPROCESSORPROC DialogCreatingProc;
  HINSTANCE         hInstance;

  DWORD             dwRenderKind;
  tRenderPriority   Priority;

  //returns TRUE, if pSettingsDialog data member is valid.
  DllExport BOOL CreateSettingsDialog(CWnd* pOwner, WINDOWPLACEMENT* pwp);
  DllExport void ReleaseSettingsDialog();

  DllExport z3dVisualRenderDescriptor();
  DllExport ~z3dVisualRenderDescriptor();
};

//-----------------------------------------
// flags used in z3dRenderPresetDescriptor:
#define RENDER_PRESET_LOCKSOBJECT   0x0001

struct z3dRenderPresetDescriptor
{
  char*             pszPresetName;
  CDialog*          pSettingsDialog;

  PLUGPROCESSORPROC DialogCreatingProc;
  HINSTANCE         hInstance;

  DWORD             nFlags;
  z3dVisualUpdaters SetOfProcs;

  //returns TRUE, if pSettingsDialog data member is valid.
  DllExport BOOL CreateSettingsDialog(CWnd* pOwner, WINDOWPLACEMENT* pwp);
  DllExport void ReleaseSettingsDialog();

  DllExport z3dRenderPresetDescriptor();
  DllExport ~z3dRenderPresetDescriptor();
};

class CProcsList;

struct CProcsListSet
{
  CProcsList*  LButtonDown;
  CProcsList*  RButtonDown;
  CProcsList*  MouseMoveL;
  CProcsList*  MouseMoveR;
  CProcsList*  MouseMove;
  CProcsList*  LButtonUp;
  CProcsList*  RButtonUp;
  CProcsList*  Key;

  CProcsList*  Render;
  CProcsList*  Rendered;          //(use Render.APost)
  CProcsList*  ViewRedraw;        //use APost only.

  CProcsList*  SceneRebuild;

  CProcsList*  SceneChanged;
  CProcsList*  SelectionChanged;  //APost only
  CProcsList*  MarkageChanged;    //APost only
  CProcsList*  VisibilityChanged;//APost only
  CProcsList*  MiscChanged;      //APost only
  CProcsList*  LevelChanged;      //APost only
  CProcsList*  EditModeChanged;  //APost only
  CProcsList*  ModeChanged;      //APost only
  CProcsList*  DeviceChanged;    //APost only

  CProcsList*  SceneNew;
  CProcsList*  SceneOpen;
  CProcsList*  SceneSave;
  CProcsList*  SceneQuit;

  CProcsList*  ProgramLoadUnload;//unused
  CProcsList*  PluginsLoadUnload;//unused

  //Adds entry to the list. The entries are reffered by names,
  //so the name should be unique.
  DllExport DWORD  AddProc(
          DWORD              nEvents, //Z3D_EVENT_
          char*              Name,
          PLUGPROCESSORPROC  APre,
          PLUGPROCESSORPROC  APost,
          PLUGPROCESSORPROC  OnAdd,
          PLUGPROCESSORPROC  OnRemove,
          tProcParams*       params,
          HINSTANCE          handle);
  //Removes the proc, reffered by Name.
  DllExport DWORD RemoveProc(DWORD nEvents, char* Name, tProcParams* params);
};

struct ToolBars
{
  CToolBar      *pBar;
  CToolTipCtrl  *pTip;
  BOOL          Active;
  long          IDindex;  //unused
  char*         Name;     //title
  BOOL          Internal; //pBar will not be deleted if it's TRUE

  DllExport  ToolBars();
};

struct DialogBars
{
  CRollUpBar      *pBar;  
  CToolTipCtrl    *pTip;
  HINSTANCE       hDLL;     //DLL's instance
  BOOL            Active;
  long            IDindex;  //unused
  char*           Name;     //title
  BOOL            Internal; //pBar will not be deleted
  PLUGPROCESSORPROC  ActivateProc;
  PLUGPROCESSORPROC  DeactivateProc;
  PLUGPROCESSORPROC  OnUnloadFloatBarProc;
  PLUGPROCESSORPROC  OnSceneLBDProc;
  PLUGPROCESSORPROC  OnSceneRBDProc;
  PLUGPROCESSORPROC  OnSceneLBUProc;
  PLUGPROCESSORPROC  OnSceneRBUProc;
  PLUGPROCESSORPROC  OnSceneMMProc;
  PLUGPROCESSORPROC  OnSceneKeyProc;
  PLUGPROCESSORPROC  OnSceneMMLBDProc;
  PLUGPROCESSORPROC  OnSceneMMRBDProc;
  PLUGPROCESSORPROC  OnSceneChangedProc;
  PLUGPROCESSORPROC  OnSceneRebuildProc;
  PLUGPROCESSORPROC  OnSelectionChangedProc;
  PLUGPROCESSORPROC  OnMarkageChangedProc;
  PLUGPROCESSORPROC  OnVisibilityChangedProc;
  PLUGPROCESSORPROC  OnMiscChangedProc;
  PLUGPROCESSORPROC  OnLevelChangedProc;
  PLUGPROCESSORPROC  OnEditModeChangedProc;
  PLUGPROCESSORPROC  OnModeChangedProc;
  PLUGPROCESSORPROC  OnDeviceChangedProc;
  PLUGPROCESSORPROC  OnSceneRender;
  PLUGPROCESSORPROC  OnSceneRendered;

  DllExport DialogBars();
};

struct z3dViewDescriptor
{
  char      ViewTitle[16];
  ViewMode  Kind;

  DWORD     nFlags;
  POINT     BackImageSize;
  long      PixelsPerUnit;  

  RECT      ClientRect;
  float     Zoom;
  float     OffsetX,
            OffsetY;
// Custom-3D
  DWORD     DeviceFlags;
  DWORD     Reserved;

  BYTE      Perspectived;
  BYTE      MouseSensitivity; //1..10;
  BYTE      nReserv[2];

  long      BackgroundImageIndex;
  
  DWORD     LStandart;
  DWORD     LAmbient;
  DWORD     Background;
  DWORD     WireFrame;

  struct    {float x,y,z;}Camera;
  struct    {float x,y,z;}CamTarget;
  struct    {float x,y,z;}CamUpVector;
  float     CamFOV;
  float     CamSlope;

  float     BackImageOffsetX,
            BackImageOffsetY,
            BackImageZoom;
  DllExport z3dViewDescriptor();
};


struct tProcParams
{
  DWORD                StructSize;       //sizeof(tProcParams)
  CDC*                 pdc;              //view's DC;
  CDirect3D*           pD3D;             //ZModeler's 3DEngine
  tObjectSet*          Objects;          //scene objects
  tSplines*            Splines;          //splines
  UINT*                nFlags;           //action flags (MF_LBUTTON, MF_SHIFT etc.)
  POINT*               loc;              //screen point of action
  tPOINT*              ProcessedLocation;//scene 3D point of action (trustable)
  tPOINT*              LastMovedAt;      //last 3D point of mouse movement
  tPOINT*              LastPressedAt;    //last 3D point of mouse click
  float*               ApplyX;           //amount of applyment was performed before (x-scale etc.)
  float*               ApplyY;           //amount of applyment was performed before (y-scale etc.)
  z3dViewDescriptor*   ViewDesc;         //active's View
  tUndoStack*          pStack;           //UndoStack.
  SYSTEMREQUESTPROC    sysp;             //system request proc.
  PLUGUNDOPROC         LBDUndoProc;      //you can used these pointers in your plug.
  PLUGUNDOPROC         RBDUndoProc;
  PLUGPTRASPARAMPROC   LBDUndoRelease;
  PLUGPTRASPARAMPROC   RBDUndoRelease;
  PLUGPTRASPARAMPROC   LBDCreateRedo;
  PLUGPTRASPARAMPROC   RBDCreateRedo;
  HINSTANCE            DllHandle;        //your plugin's hinstance
  HINSTANCE            AppHandle;        //ZModeler's hinstance
  CWinApp*             pApp;             //ZModeler's CWinApp
  void*                pDATA;            //custom data;
  DWORD                nDataFlags;       //future capability
  DWORD                reserv;           //future capability
  CProcsListSet*       ListSet;          //set of "action lists".

  DllExport tProcParams();
};



///////////////////////////////////////////////
// Set of procs for standart processing plugin
typedef struct z3dProcsSet
{
  HINSTANCE            DllHandleLB;
  HINSTANCE            DllHandleRB;
  //verified in menubars' and toolbars buttons:
  BOOL                 bAlternative;
  DWORD                nID;  //for help and other stuff
  PLUGPROCESSORPROC    OnLBDProc;
  PLUGPROCESSORPROC    OnLBUProc;
  PLUGPROCESSORPROC    OnMMProc;
  PLUGPROCESSORPROC    OnMMLBDProc;
  PLUGPROCESSORPROC    OnMMRBDProc;
  PLUGPROCESSORPROC    OnRBDProc;
  PLUGPROCESSORPROC    OnRBUProc;
  PLUGPROCESSORPROC    OnPreModeProc;
  PLUGPROCESSORPROC    OnPostModeProc;
  PLUGPROCESSORPROC    OnKeyProc;
  PLUGPROCESSORPROC    OnHelpProc;
  PLUGUNDOPROC         LBDUndoProc;
  PLUGUNDOPROC         RBDUndoProc;
  PLUGPTRASPARAMPROC   LBDUndoRelease;
  PLUGPTRASPARAMPROC   RBDUndoRelease;
  PLUGPTRASPARAMPROC   LBDCreateRedo;
  PLUGPTRASPARAMPROC   RBDCreateRedo;
  
  HCURSOR   hcNorm,
            hcShift,
            hcCtrl,
            hcLBNorm,
            hcLBShift,
            hcLBCtrl,
            hcRBNorm,
            hcRBShift,
            hcRBCtrl;
  DllExport z3dProcsSet();
}z3dProcsSet;


typedef struct sPlugin
{
  DWORD               PlugSupports;
  HINSTANCE           hIns;

  //pointer is char* pPathName
  PLUGPTRASPARAMPROC  TextureLoadProc;    //TextureLoader

  //tProcParams* pParams where:
  // void* pDATA is CFile* pFile
  // DWORD nViewFlags is the ChunkID to read (=0 when saving)
  // DWORD nDataFlags is the ChunkSize (bytes to read)
  // return value is number of bytes written/read.
  PLUGPROCESSORPROC   ReadChunkProc;      //SceneOpenSave
  PLUGPROCESSORPROC   WriteChunksProc;    //SceneOpenSave

  FILTERIMPEXPPROC    ImpProc;            // filters
  FILTERIMPEXPPROC    ExpProc;            // filters
  BOOL                DynLoad;            //LoadLibrary on proccall
  char*               pathname;
  char*               filtermask;         //filters
  char*               filterextension;    //filters
  char*               textureextensions;  //Z3D_PLUGSUPPORTS_TEXTURELOADING
  char*               miscflagstreating;  //Z3D_PLUGSUPPORTS_MISCFLAGS

  DllExport void Own(struct sPlugin& plug);
  DllExport void Preload(BOOL bForcePreload = FALSE); //loads, if it's Dynamic
  DllExport void Release(BOOL bForceRelease = FALSE); //releases, if it's Dynamic;
  DllExport sPlugin();
  DllExport ~sPlugin();
}sPlugin;


typedef struct MenuItemProcs
{
  DWORD              PlugIndex;      //in set of plugins.
  DWORD              ProcType;        //single (dialog), on/off call

  PLUGPROCESSORPROC  OnLoadProc;      //called after loading and adding to the menu;
  PLUGPROCESSORPROC  UnloadProc;      //mast call before closing application

  //if not dynload use directly the following things:
  PLUGPROCESSORPROC  ActivateProc;    //menu item selected.
  PLUGPROCESSORPROC  DeactivateProc; //optionally
  CString            ProcName;        //title.
}MenuItemProcs;


#endif
